package gov.va.med.mhv.admin.service.impl.vastaff;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import gov.va.med.mhv.admin.converter.EmpOrgRoleHistoryConverter;
import gov.va.med.mhv.admin.converter.EmployeeConverter;
import gov.va.med.mhv.admin.converter.EmployeeOrgRoleConverter;
import gov.va.med.mhv.admin.converter.OrgConverter;
import gov.va.med.mhv.admin.converter.OrgRoleConverter;
import gov.va.med.mhv.admin.converter.RoleConverter;
import gov.va.med.mhv.admin.dto.EmployeeDTO;
import gov.va.med.mhv.admin.dto.EmployeeOrgRoleDTO;
import gov.va.med.mhv.admin.dto.EmployeeOrgRoleHistoryDTO;
import gov.va.med.mhv.admin.dto.EmployeeSearchResult;
import gov.va.med.mhv.admin.dto.OrgDTO;
import gov.va.med.mhv.admin.dto.RoleDTO;
import gov.va.med.mhv.admin.model.Employee;
import gov.va.med.mhv.admin.model.EmployeeOrgRole;
import gov.va.med.mhv.admin.model.EmployeeOrgRoleHistory;
import gov.va.med.mhv.admin.model.Org;
import gov.va.med.mhv.admin.model.Role;
import gov.va.med.mhv.admin.repository.EmployeeOrgRoleHistoryRepository;
import gov.va.med.mhv.admin.repository.EmployeeOrgRoleRepository;
import gov.va.med.mhv.admin.repository.EmployeeRepository;
import gov.va.med.mhv.admin.repository.OrganizationRepository;
import gov.va.med.mhv.admin.repository.RoleRepository;
import gov.va.med.mhv.admin.service.vastaff.EmployeeRoleManagementService;
import gov.va.med.mhv.admin.service.vastaff.EmployeeSearchService;
import gov.va.med.mhv.admin.util.MessagesUtil;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.ResponseUtil;

@Path("/")
@Service("employeeRoleManagementService")
public class EmployeeRoleManagementServiceImpl implements EmployeeRoleManagementService {

	@Autowired
	private OrganizationRepository organizationRepository;

	@Autowired
	private EmployeeOrgRoleRepository employeeOrgRoleRepository;

	@Autowired
	private EmployeeRepository employeeRepository;

	@Autowired
	private RoleRepository roleRepository;

	@Autowired
	private EmployeeSearchService employeeSearchService;

	@Autowired
	private MessagesUtil messagesUtil;

	@Autowired
	private EmployeeOrgRoleHistoryRepository employeeOrgRoleHistoryRepository;

	@Autowired
	private OrgRoleConverter orgRoleConverter;

	@Autowired
	private EmployeeOrgRoleConverter employeeOrgRoleConverter;

	@Autowired
	private EmpOrgRoleHistoryConverter empOrgRoleHistoryConverter;

	@Autowired
	private OrgConverter orgConverter;

	@Autowired
	private RoleConverter roleConverter;

	@Autowired
	private EmployeeConverter employeeConverter;

	@Override
	@POST
	@Path("/updateEmployeeOrganizationRole/{employeeId}/{employeeOrgRoleId}/{isActive}")
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Transactional
	public EmployeeOrgRoleDTO updateOrgRoleStatus(@PathParam("employeeId") Long employeeId,
			@PathParam("employeeOrgRoleId") Long employeeOrgRoleId, @PathParam("isActive") Boolean isActive)
			throws MHVException {

		EmployeeOrgRoleHistory employeeOrganizationRoleHistory = new EmployeeOrgRoleHistory();
		EmployeeOrgRole empOrgRole = null;
		boolean hasPermission = false;

		try {
			// if this is an existing item we are trying to deactivate, need to
			// make sure there is going to be
			// another user in this role at this org
			empOrgRole = employeeOrgRoleRepository.findById(employeeOrgRoleId).get();
			if (!isActive) {
				List<EmployeeOrgRole> results = employeeOrgRoleRepository
						.getActiveRoleAssignments(empOrgRole.getOrganization().getId(), empOrgRole.getRole().getId());

				if (results != null && results.size() < 1) {
					throw new MHVException(messagesUtil.getCannotRemoveLastUser());
				}
			}

			// outer if statement to ensure user has access to even attempt to
			// edit this role

			List<EmployeeOrgRole> employeeOrgRoles = employeeOrgRoleRepository
					.getEmployeeOrgRolesEmployeeCanManage(employeeId);

			// List<EmployeeOrgRoleDTO> orgRoleDTOs =
			// getEmployeeOrganizationRolesEmployeeCanManage(employeeId);
			if (employeeOrgRoles != null && employeeOrgRoles.size() > 0) {
				for (EmployeeOrgRole tempEmpOrgRole : employeeOrgRoles) {
					if (tempEmpOrgRole.getRole().getName().equalsIgnoreCase(empOrgRole.getRole().getName())
							&& tempEmpOrgRole.getOrganization().getName()
									.equalsIgnoreCase(empOrgRole.getOrganization().getName())) {
						hasPermission = true;
						break;
					}
				}
			}

			if (hasPermission) {

				// if(employeeOrgRoles.contains(empOrgRole)){

				// attempt to save entity

				empOrgRole.setActive(isActive);
				empOrgRole = employeeOrgRoleRepository.save(empOrgRole);

				Employee requestingEmployee = employeeRepository.findById(employeeId).get();
				employeeOrganizationRoleHistory.setEmployeeOrgRole(empOrgRole);
				employeeOrganizationRoleHistory.setPerformingEmployee(requestingEmployee);
				employeeOrganizationRoleHistory.setModificationDate(new Date());
				// employeeOrganizationRoleHistory.setOplock(1);
				if (empOrgRole.getActive()) {
					employeeOrganizationRoleHistory.setRoleAction("Activate");
				} else {
					employeeOrganizationRoleHistory.setRoleAction("Deactivate");
				}
				employeeOrganizationRoleHistory = employeeOrgRoleHistoryRepository
						.save(employeeOrganizationRoleHistory);
			} else {
				throw new MHVException(messagesUtil.getNoAssignmentPermission());
			}
		} catch (Exception e) {
			throw new MHVException(e);
		}

		return orgRoleConverter.convert(empOrgRole);

	}

	/**
	 * Execute the AssignEmployeeOrganizationRole service
	 *
	 * @return EmployeeOrganizationRoleServiceResponse
	 */
	@Override
	@POST
	@Path("/assignEmployeeOrganizationRole/{requestingEmployeeId}/{userName}/{orgId}/{roleId}")
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Transactional
	public EmployeeOrgRoleDTO assignEmployeeOrganizationRole(
			@PathParam("requestingEmployeeId") Long requestingEmployeeId,
			@PathParam("userName") String employeeUserName, @PathParam("orgId") Long orgId,
			@PathParam("roleId") Long roleId) throws MHVException {
		ResponseUtil response = new ResponseUtil();
		EmployeeOrgRole newEmpOrgRole = new EmployeeOrgRole();
		List<EmployeeOrgRole> empOrgRoleList = new ArrayList<EmployeeOrgRole>();
		String userName = null;
		Employee employee = null;
		try {
			if (employeeUserName != null) {
				userName = employeeUserName.toLowerCase().trim();
			}

			Employee requestingEmployee = employeeRepository.findById(requestingEmployeeId).get();

			Role role = roleRepository.findById(roleId).get();

			// EmployeeDTO requestingToEmployee =
			// findEmployeeByUserName(userName);
			Org org = organizationRepository.findById(orgId).get();
			boolean hasPermission = false;
			boolean hasAssignRolePermission = false;

			// outer if statement to ensure requesting employee has permissions
			// to perform this role assignment
			if (requestingEmployee != null) {
				List<Role> roles = employeeOrgRoleRepository
						.getRolesAtOrganizationEmployeeCanManage(requestingEmployee.getId(), orgId);

				if (roles != null && roles.size() > 0) {
					for (Role tempRole : roles) {
						if (tempRole.getName().equalsIgnoreCase(role.getName())) {
							hasAssignRolePermission = true;
							break;
						}
					}
				}
			}
			if (hasAssignRolePermission) {
				EmployeeOrgRole existingAssignment = null;
				EmployeeDTO employeeDTO = getEmployeeByUserName(userName);
				// Check if this is a duplicate Assignment
				if (employeeDTO != null) {
					if (employeeDTO.getEmployeeId() == null) {
						// employeeDTO.setOplock(1);
						employee = employeeRepository.save(employeeConverter.convert(employeeDTO));
						if (employee.getId() != null) {
							empOrgRoleList = employeeOrgRoleRepository
									.getEmployeeOrgRolesAssignedToEmployee(employee.getId());
						}
					} else {
						empOrgRoleList = employeeOrgRoleRepository
								.getEmployeeOrgRolesAssignedToEmployee(employeeDTO.getEmployeeId());
					}
					// get all existing assignments for employee, loop over each
					// and see if its a duplicate
					if (empOrgRoleList != null && empOrgRoleList.size() > 0) {
						for (EmployeeOrgRole empOrgRole : empOrgRoleList) {
							existingAssignment = empOrgRole;

							// if existing assignment org matches this org, and
							// existing role matches this role, its dup
							if (existingAssignment.getOrganization().getName().equalsIgnoreCase(org.getName())
									&& existingAssignment.getRole().getName().equalsIgnoreCase(role.getName())) {
								hasPermission = true;

							}
						}
					}
				}
				if (hasPermission) {
					LinkedHashMap<String, String> validationErrors = response.getValidationErrors();
					validationErrors.put("The employee is already in this role at this organization.",
							"The employee is already in this role at this organization.");
					response.setValidationErrors(validationErrors);
					throw new MHVException(response.getInfoMessages(), response.getValidationErrors(),
							response.getFailureMessage());
					// throw new
					// MHVException(messagesUtil.getDuplicateAssignment());
				}
				// employee = employeeRepository.save(employee);
				if (employee != null) {
					newEmpOrgRole.setEmployee(employee);
				} else {
					newEmpOrgRole.setEmployee(employeeConverter.convert(employeeDTO));
				}
				// newEmpOrgRole.setId(999999999L);
				newEmpOrgRole.setActive(true);
				newEmpOrgRole.setOrganization(org);
				newEmpOrgRole.setRole(role);
				// newEmpOrgRole.setOplock(1);

				newEmpOrgRole = employeeOrgRoleRepository.save(newEmpOrgRole);
				// check for errors, and if not present, setup and save the
				// role history entry
				EmployeeOrgRoleHistory employeeOrganizationRoleHistory = new EmployeeOrgRoleHistory();
				// employeeOrganizationRoleHistory.setOplock(1);
				employeeOrganizationRoleHistory.setEmployeeOrgRole(newEmpOrgRole);
				employeeOrganizationRoleHistory.setPerformingEmployee(requestingEmployee);
				employeeOrganizationRoleHistory.setRoleAction("Add");
				employeeOrganizationRoleHistory.setModificationDate(new Date());
				employeeOrgRoleHistoryRepository.save(employeeOrganizationRoleHistory);
			} else {
				LinkedHashMap<String, String> validationErrors = response.getValidationErrors();
				validationErrors.put("You do not have the permissions to perform this operation.",
						"You do not have the permissions to perform this operation.");
				response.setValidationErrors(validationErrors);
				throw new MHVException(response.getInfoMessages(), response.getValidationErrors(),
						response.getFailureMessage());
			}
		} catch (Exception e) {
			throw new MHVException(e);
		}
		if (newEmpOrgRole != null)
			return orgRoleConverter.convert(newEmpOrgRole);
		else
			return null;
	}

	/**
	 * Execute the GetEmployeeByUserName service VA Employees can exist in
	 * Active Directory, and locally in our internal DB If an employee is found
	 * in AD, but not yet saved locally, this method will return the employee
	 * entity, not in a persistant state.
	 * 
	 * @return EmployeeServiceResponse
	 */
	@Override
	@GET
	@Path("/getEmployeeByUserName/{userName}")
	@Produces(MediaType.APPLICATION_JSON)
	public EmployeeDTO getEmployeeByUserName(@PathParam("userName") String userName) throws MHVException {
		EmployeeDTO employeeDTO = null;
		ResponseUtil response = new ResponseUtil();

		if (StringUtils.isNotEmpty(userName)) {
			userName = userName.toLowerCase().trim();
			EmployeeSearchResult empSearchResult = new EmployeeSearchResult();
			try {
				// search for employee
				employeeDTO = findEmployeeByUserName(userName);

				// fetch employee from active directory
				List<EmployeeSearchResult> empSearchResults = employeeSearchService.searchByUserName(userName);

				// if employee not in our environment and also not found in
				// active directory, error
				if (employeeDTO == null && empSearchResults == null) {

					response.setFailure(true);
					response.setFailureMessage("The specified user name " + userName + " does not exist");
					throw new MHVException("The specified user name " + userName + " does not exist");

				}
				// else, assuming all is well, update employee entity with
				// most recent data from active directory
				if (employeeDTO == null) {
					employeeDTO = new EmployeeDTO();
				}
				employeeDTO.setUserName(userName);
				if (empSearchResults != null && empSearchResults.size() > 0) {
					EmployeeSearchResult employeeSearchResult = empSearchResults.get(0);
					if (employeeSearchResult != null) {
						employeeDTO.setFirstName(employeeSearchResult.getFirstName());
						employeeDTO.setLastName(employeeSearchResult.getLastName());
					}
				}
			} catch (Exception e) {
				throw new MHVException(e);
			}
		} else {
			throw new IllegalArgumentException("User Name can not be null");
		}

		return employeeDTO;
	}

	private EmployeeDTO findEmployeeByUserName(String employeeUserName) throws MHVException {
		EmployeeDTO employeeDTO = null;
		String userName = null;
		try {
			if (employeeUserName == null) {
				throw new IllegalArgumentException("User Name can not be null");
			}
			userName = employeeUserName.toLowerCase().trim();
			Employee employee = employeeRepository.findEmployeeByUserName(userName);
			if (employee != null) {
				employeeDTO = employeeConverter.convert(employee);
			} /*
				 * else{ throw new
				 * MHVException("Employee Not Found for the userName::" +
				 * userName); }
				 */
		} catch (Exception e) {
			throw new MHVException(e);
		}
		return employeeDTO;
	}

	/**
	 * Execute the GetEmployeeOrganizationRolesAssignedToEmployee service
	 *
	 * @return EmployeeOrganizationRoleCollectionServiceResponse
	 */
	@Override
	@GET
	@Path("/getEmployeeOrgRolesAssignedToEmployee/{employeeId}")
	@Produces(MediaType.APPLICATION_JSON)
	public List<EmployeeOrgRoleDTO> getEmployeeOrgRolesAssignedToEmployee(@PathParam("employeeId") Long employeeId)
			throws MHVException {
		List<EmployeeOrgRoleDTO> employeeOrgRoleDTOs = null;
		try {
			List<EmployeeOrgRole> employeeOrgRoles = employeeOrgRoleRepository
					.getEmployeeOrgRolesAssignedToEmployee(employeeId);

			if (employeeOrgRoles != null && employeeOrgRoles.size() > 0) {
				employeeOrgRoleDTOs = orgRoleConverter.convert(employeeOrgRoles);
			} else {
				throw new MHVException("ERROR  in fetching getEmployeeOrgRolesAssignedToEmployeeByName::");
			}
		} catch (Exception e) {
			throw new MHVException("Error in fetching getOrganizationsEmployeeCanManage(): ", e);
		}
		return employeeOrgRoleDTOs;
	}

	/**
	 * Execute the getEmployeeOrganizationRolesAssignedToEmployeeByName service
	 *
	 * @return EmployeeOrganizationRoleCollectionServiceResponse
	 */

	@Override
	@GET
	@Path("/getEmployeeOrgRolesAssignedToEmployeeByName/{userName}")
	@Produces(MediaType.APPLICATION_JSON)
	public List<EmployeeOrgRoleDTO> getEmployeeOrgRolesAssignedToEmployeeByName(@PathParam("userName") String userName)
			throws MHVException {
		List<EmployeeOrgRoleDTO> employeeOrgRoleDTOs = null;
		try {
			List<EmployeeOrgRole> employeeOrgRoles = employeeOrgRoleRepository
					.getEmployeeOrgRolesAssignedToEmployeeByName(userName);
			if (employeeOrgRoles != null && employeeOrgRoles.size() > 0) {
				employeeOrgRoleDTOs = employeeOrgRoleConverter.convert(employeeOrgRoles);
			} 
		} catch (Exception e) {
			throw new MHVException("Error in fetching getEmployeeOrgRolesAssignedToEmployeeByName(): ", e);
		}
		return employeeOrgRoleDTOs;
	}

	/**
	 * Execute the GetRoleHistoriesForEmployee service
	 *
	 * @return EmployeeOrganizationRoleHistoryCollectionServiceResponse
	 */

	@Override
	@GET
	@Path("/getRoleHistoriesForEmployee/{employeeId}")
	@Produces(MediaType.APPLICATION_JSON)
	public List<EmployeeOrgRoleHistoryDTO> getRoleHistoriesForEmployee(@PathParam("employeeId") Long employeeId)
			throws MHVException {
		List<EmployeeOrgRoleHistoryDTO> empOrgRoleHistoryDTOs = null;
		try {
			List<EmployeeOrgRoleHistory> empOrgRoleHistory = employeeOrgRoleHistoryRepository
					.getRoleHistoriesForEmployee(employeeId);

			if (empOrgRoleHistory != null && empOrgRoleHistory.size() > 0) {
				empOrgRoleHistoryDTOs = empOrgRoleHistoryConverter.convert(empOrgRoleHistory);
			} 
		} catch (Exception e) {
			throw new MHVException("Error in fetching getRoleHistoriesForEmployee()", e);
		}
		return empOrgRoleHistoryDTOs;
	}

	/**
	 * Execute the GetOrganizationsEmployeeCanManage service
	 *
	 * @return OrganizationTypeDefCollectionServiceResponse
	 */

	@Override
	@GET
	@Path("/getOrganizationsEmployeeCanManage/{employeeId}")
	@Produces(MediaType.APPLICATION_JSON)
	public List<OrgDTO> getOrganizationsEmployeeCanManage(@PathParam("employeeId") Long employeeId)
			throws MHVException {
		List<OrgDTO> OrgDTOs = null;
		try {
			List<Org> orgs = organizationRepository.getOrganizationsEmployeeCanManage(employeeId);

			if (orgs != null && orgs.size() > 0) {
				OrgDTOs = orgConverter.convert(orgs);
			} 
		} catch (Exception e) {
			throw new MHVException("Error in fetching getOrganizationsEmployeeCanManage(): ", e);
		}
		return OrgDTOs;
	}

	/**
	 * Execute the GetRolesAtOrgEmployeeCanManage service
	 *
	 * @return RoleCollectionServiceResponse
	 */

	@Override
	@GET
	@Path("/getRolesAtOrganizationEmployeeCanManage/{employeeId}/{organizationId}")
	@Produces(MediaType.APPLICATION_JSON)
	public List<RoleDTO> getRolesAtOrganizationEmployeeCanManage(@PathParam("employeeId") Long employeeId,
			@PathParam("organizationId") Long organizationId) throws MHVException {
		List<RoleDTO> roleDTOs = null;
		try {
			List<Role> roles = employeeOrgRoleRepository.getRolesAtOrganizationEmployeeCanManage(employeeId,
					organizationId);
			if (roles != null && roles.size() > 0) {
				roleDTOs = roleConverter.convert(roles);
			} /*else {
				throw new MHVException("ERROR  in fetching getRolesAtOrganizationEmployeeCanManage::");
			}*/
		} catch (Exception e) {
			throw new MHVException("Error in fetching getRolesAtOrganizationEmployeeCanManage(): ", e);
		}
		return roleDTOs;
	}

	/**
	 * Execute the GetEmployeeOrganizationRolesEmployeeCanManage service
	 *
	 * @return EmployeeOrganizationRoleCollectionServiceResponse
	 */

	@Override
	@GET
	@Path("/getEmployeeOrganizationRolesEmployeeCanManage/{employeeId}")
	@Produces(MediaType.APPLICATION_JSON)
	public List<EmployeeOrgRoleDTO> getEmployeeOrganizationRolesEmployeeCanManage(
			@PathParam("employeeId") Long employeeId) throws MHVException {
		List<EmployeeOrgRoleDTO> empOrgRoleDTOs = null;
		try {
			List<EmployeeOrgRole> empOrgRoles = employeeOrgRoleRepository
					.getEmployeeOrgRolesEmployeeCanManage(employeeId);

			if (empOrgRoles != null && empOrgRoles.size() > 0) {
				empOrgRoleDTOs = employeeOrgRoleConverter.convert(empOrgRoles);
			} 
		} catch (Exception e) {
			throw new MHVException("Error in fetching getEmployeeOrganizationRolesEmployeeCanManage(): ", e);
		}
		return empOrgRoleDTOs;
	}

	/**
	 * 
	 * GetOrganizationsOfTypeWhereEmployeeHasRole This returns organizations of
	 * a specific type for an employee if they have an active role assignment.
	 * 
	 * For instance, this query could pull orgs of type "facility" where user
	 * has active "ROI Admin" role. This will be useful for numerous other
	 * components, but not used by MUR itself.
	 * 
	 * Execute the GetOrganizationsOfTypeWhereEmployeeHasRole service
	 *
	 * @return OrganizationCollectionServiceResponse
	 * 
	 */

	@Override
	@GET
	@Path("/getOrganizationsOfTypeWhereEmployeeHasRole/{empId}/{orgType}/{roleName}")
	@Produces(MediaType.APPLICATION_JSON)
	public List<OrgDTO> getOrganizationsOfTypeWhereEmployeeHasRole(@PathParam("empId") Long empId,
			@PathParam("orgType") String orgType, @PathParam("roleName") String roleName) throws MHVException {
		List<OrgDTO> orgsDTOs = null;
		try {
			List<Org> orgs = organizationRepository.getOrganizationsOfTypeWhereEmployeeHasRole(empId, orgType,
					roleName);

			if (orgs != null && orgs.size() > 0) {
				orgsDTOs = orgConverter.convert(orgs);
			} 
		} catch (Exception e) {
			throw new MHVException("Error in fetching getOrganizationsOfTypeWhereEmployeeHasRole()", e);
		}
		return orgsDTOs;
	}

	/**
	 * Execute the GetRolesByName service
	 *
	 * @return RoleCollectionServiceResponse
	 */
	@Override
	@GET
	@Path("/getRoleByName/{roleName}")
	@Produces(MediaType.APPLICATION_JSON)
	public RoleDTO getRoleByName(@PathParam("roleName") String roleName) throws MHVException {
		RoleDTO roleDTO = null;
		try {
			Role role = roleRepository.getRoleByName(roleName);

			if (role != null) {
				roleDTO = roleConverter.convert(role);
			} 
		} catch (Exception e) {
			throw new MHVException("Error in fetching getRolesByName()", e);
		}
		return roleDTO;
	}

	@Override
	@GET
	@Path("/findByEmpOrgRoleId/{employeeOrgRoleId}")
	@Produces(MediaType.APPLICATION_JSON)
	public EmployeeOrgRoleDTO findByEmpOrgRoleId(@PathParam("employeeId") Long employeeOrgRoleId) throws MHVException {
		EmployeeOrgRoleDTO employeeOrgRoleDTO = null;
		try {
			EmployeeOrgRole employeeOrgRole = employeeOrgRoleRepository.findById(employeeOrgRoleId).get();
			if (employeeOrgRole != null) {
				employeeOrgRoleDTO = orgRoleConverter.convert(employeeOrgRole);
			} 
		} catch (Exception e) {
			throw new MHVException(e);
		}
		return employeeOrgRoleDTO;
	}

}